//OHSAT GAMES MEGASAMPLER 03 - MEGAPONG Options 
//MEGATEAMWORK Makes the MEGADREAM Work 
//Date: 02/10/2026


//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
#include "menu.h"
#include "megapong.h"
#include "megarunner.h"
#include "megalaga.h"
#include "megatiler.h"

// declare splash

static u16 skipAllSplashes = FALSE;
static void showOneSplash(const Image* img, u16 frames);
void showSplash(void);

int main()
{
    //SHOW SPLASH ONCE
    showSplash();

    while(1)
    {
        int choice = menu_show();   // Returns 1–4

        switch(choice)
        {
            case 1:
                runMegapong();
                break;
            case 2:
                runMegarunner();
                break;
            case 3:
                runMegalaga();
                break;
            case 4:
                runMegatiler();
                break;
        }

        //
        // CLEAN RESET BETWEEN GAMES
        //
        XGM_stopPlay();             // stop any XGM music
        SND_PCM_stopPlay();         // stop PCM channel 0 (optional)
        SPR_reset();                // remove all sprite engine data
        VDP_resetScreen();          // clear VRAM + planes
        JOY_setEventHandler(NULL);  // clear input callbacks
    }

    return 0;
}

static void showOneSplash(const Image* img, u16 frames)
{
    if (skipAllSplashes)
        return;

    VDP_resetScreen();
    SPR_reset();

    PAL_setPaletteColors(0, (u16*)palette_black, 64);

    VDP_drawImageEx(
        BG_A,
        img,
        TILE_ATTR_FULL(PAL0, FALSE, FALSE, FALSE, TILE_USER_INDEX),
        0, 0,
        FALSE,
        TRUE
    );

    // Fade in
    PAL_fadeInAll(img->palette->data, 90, FALSE);

    // Hold image (START skips ALL splashes)
    for (u16 i = 0; i < frames; i++)
    {
        SYS_doVBlankProcess();

        if (JOY_readJoypad(JOY_1) & BUTTON_START)
        {
            skipAllSplashes = TRUE;
            break;
        }
    }

    // Fade out only if not skipping everything
    if (!skipAllSplashes)
        PAL_fadeOutAll(90, FALSE);
}


void showSplash(void)
{
    JOY_init();
    skipAllSplashes = FALSE;

    showOneSplash(&eikImg,      180);
    showOneSplash(&nemoxImg,    180);
    showOneSplash(&joustxImg,   180);
    showOneSplash(&metroidxImg, 180);
    showOneSplash(&demonxImg,   180);
    showOneSplash(&bubblexImg,  180);
    showOneSplash(&pigsyImg,    180);

    //Possible Bug Fix 2
    // Wait for START release so it doesn't carry into menu
    while (JOY_readJoypad(JOY_1) & BUTTON_START)
    {
        SYS_doVBlankProcess();
    }

    VDP_resetScreen();
}

////////////////////CHANGE LOG////////////////////////////

/*

1. Added menu options to MEGAPONG: Difficulty, Paddle Size, Ball Type, P1 Controls, P2 Controls, Win Limit
2. Updated ball sprites and match title to correlate to ball sprite selction
3. Added match limits and countdown timer between rounds. 
4. Updated Chosby and Sonic sprites. 
5. Set Nemo sprite to use Row 7 death animation as Nemo ball sprite
6. Added tile fade-in/fade-out on game-start/game-over states


*/

/////////////////////////////////////////////////////////

///////////////////NOTES////////////////////////////////

/*

1. Had to account for BUTTON_B conflict between menu.c and Megapong menu in 
megapong.c menu code. 
2. Was having force-fielding/overlap issues with ball sprites when trying to use anything
other than exact dimensions for various ball sprites. 

*/

/////////////////////////////////////////////////////////

////////////////EXPERIMENTATION IDEAS////////////////////

/*

1. It may be useful to use the low-res mode H32 for a splash screen or screens
2. Rather than using still images you could have a splash screen with animated sprites. 
3. Consider doing OHSAT text-scroll screen as wait-screen 

*/

///////////////////ERROR HANDLING//////////////////////

/*


*/

//////////////////////////////////////////////////////



